/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.more_bows_and_arrows.core.item;

import java.util.List;
import neoforge.com.cursee.more_bows_and_arrows.core.entity.TieredArrowEntity;
import neoforge.com.cursee.more_bows_and_arrows.core.tier.ArrowTier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TieredArrowItem
extends ArrowItem {
    public final ArrowTier tier;

    public TieredArrowItem(ArrowTier tier) {
        super(new Item.Properties());
        this.tier = tier;
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @NotNull Item.TooltipContext context, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        if (!(itemStack.getItem() instanceof TieredArrowItem)) {
            return;
        }
        components.add((Component)Component.translatable((String)("lore.more_bows_and_arrows." + this.tier.getSerializedName() + "_arrow1")));
        components.add((Component)Component.translatable((String)("lore.more_bows_and_arrows." + this.tier.getSerializedName() + "_arrow2")));
        components.add((Component)Component.translatable((String)("lore.more_bows_and_arrows." + this.tier.getSerializedName() + "_arrow_damage")));
        super.appendHoverText(itemStack, context, components, flag);
    }

    @NotNull
    public AbstractArrow createArrow(@NotNull Level level, @NotNull ItemStack $$1, @NotNull LivingEntity livingEntity, @Nullable ItemStack $$3) {
        return new TieredArrowEntity(livingEntity, level, this.tier);
    }
}

